<?php

namespace App;

class Auth
{
    private $apiKey;

    public function __construct($request)
    {
        $this->apiKey = $request->getHeader('X-API-KEY') ?? $request->get('api_key');
    }

    public function authenticate($validKeys = [])
    {
        if (!$this->apiKey || !in_array($this->apiKey, $validKeys)) {
            Response::error('Unauthorized', 401);
        }
        return true;
    }

    public function getApiKey()
    {
        return $this->apiKey;
    }
}