-- BotAJS Git Integration - Database Schema
-- Database: dannvtuc_botajs

-- SSH Keys Table
-- Stores SSH key pairs for users
-- One key pair per user (can be used for multiple bots)
CREATE TABLE IF NOT EXISTS `ssh_keys` (
  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` VARCHAR(255) NOT NULL,
  `public_key` TEXT NOT NULL,
  `private_key` TEXT NOT NULL,
  `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_user_id` (`user_id`),
  KEY `idx_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Note: One SSH key per user_id
-- Multiple bots can use the same user's SSH key
-- When a new key is generated for a user, it replaces the old one
