# Quick Start Guide

## Installation

```bash
# 1. Navigate to project directory
cd /Users/kkt/Documents/php-git-bota

# 2. Dependencies are already installed, but if needed:
composer install

# 3. Configure your API key
nano .env
# Change: API_KEY=your-secret-api-key-here
```

## Testing Locally

### Option 1: PHP Built-in Server

```bash
cd public
php -S localhost:8000
```

Your API will be available at: `http://localhost:8000`

### Option 2: Direct API File Access

You can also call the API endpoints directly:

```bash
php api/generate-key.php
```

## Quick Test

### 1. Generate SSH Deploy Key

```bash
curl -X POST http://localhost:8000/api/git/generate-key \
  -H "X-API-KEY: your-secret-api-key-here" \
  -H "Content-Type: application/json" \
  -d '{"user_id": "test_user"}'
```

Expected response:
```json
{
  "success": true,
  "message": "Deploy key generated successfully",
  "public_key": "ssh-rsa AAAAB3NzaC1yc2EA...",
  "note": "Copy this key and add it as a Deploy Key in your GitHub repository settings"
}
```

### 2. Add Deploy Key to GitHub

1. Copy the `public_key` from the response
2. Go to your GitHub repository
3. Navigate to: **Settings → Deploy keys → Add deploy key**
4. Paste the public key
5. **Check "Allow write access"**
6. Click "Add key"

### 3. Export Bot to GitHub

```bash
curl -X POST http://localhost:8000/api/bots/export \
  -H "X-API-KEY: your-secret-api-key-here" \
  -H "Content-Type: application/json" \
  -d '{
    "user_id": "test_user",
    "botId": "YOUR_BOT_ID",
    "git_repo_url": "git@github.com:yourusername/yourrepo.git",
    "git_branch": "main",
    "commit_message": "Initial bot export",
    "user_email": "you@example.com",
    "api_key": "YOUR_BOTAJS_API_KEY"
  }'
```

### 4. Import Bot from GitHub

```bash
curl -X POST http://localhost:8000/api/bots/import \
  -H "X-API-KEY: your-secret-api-key-here" \
  -H "Content-Type: application/json" \
  -d '{
    "user_id": "test_user",
    "botId": "YOUR_BOT_ID",
    "git_repo_url": "git@github.com:yourusername/yourrepo.git",
    "git_branch": "main",
    "api_key": "YOUR_BOTAJS_API_KEY"
  }'
```

## Environment Variables

Edit `.env` file:

```env
# Your backend API key (for authenticating requests to THIS API)
API_KEY=your-secret-api-key-here

# Where to store temporary Git repositories
GIT_STORAGE_PATH=/tmp/botajs_git

# Where to store PHP sessions
PHP_SESSION_PATH=/tmp/botajs_sessions
```

## API Endpoints Summary

| Endpoint | Method | Description |
|----------|--------|-------------|
| `/api/git/generate-key` | POST | Generate SSH deploy key |
| `/api/git/get-key` | POST | Retrieve public key |
| `/api/bots/export` | POST | Export bot to GitHub |
| `/api/bots/import` | POST | Import bot from GitHub |

## Common Issues

### "SSH key not configured"
- Run generate-key endpoint first
- Ensure you're using the same `user_id` across requests

### "Permission denied (publickey)"
- Verify deploy key is added to GitHub
- Ensure "Allow write access" is checked
- Use SSH URL format: `git@github.com:user/repo.git`

### "Failed to fetch bot"
- Check your BotAJS API key is correct
- Verify the bot ID exists
- Ensure BotAJS API is accessible

### "Commands directory not found"
- Repository must contain: `bots/{botId}/commands/`
- Export a bot first to see the expected structure

## Next Steps

1. Review [README.md](README.md) for complete documentation
2. Configure your web server (Apache/Nginx) for production
3. Set up HTTPS with SSL certificate
4. Configure proper file permissions
5. Set up monitoring and logging

## Support

For issues:
- BotAJS API: https://botajs.top
- This project: Check [README.md](README.md)
